package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Received segment key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedSegmentKey {

    private final String segmentationKey;
    private final String segmentKey;

    public ReceivedSegmentKey(String segmentationKey, String segmentKey) {
        this.segmentationKey = segmentationKey;
        this.segmentKey = segmentKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSegmentationKey() {
        return segmentationKey;
    }

    public String getSegmentKey() {
        return segmentKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedSegmentKey that = (ReceivedSegmentKey) o;
        return Objects.equals(segmentationKey, that.segmentationKey) &&
                Objects.equals(segmentKey, that.segmentKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentKey);
    }

    @Override
    public String toString() {
        return "ReceivedSegmentKey{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                '}';
    }

    public static final class Builder {

        private String segmentationKey;
        private String segmentKey;

        private Builder() {
        }

        public Builder segmentationKey(String segmentationKey) {
            this.segmentationKey = segmentationKey;
            return this;
        }

        public Builder segmentKey(String segmentKey) {
            this.segmentKey = segmentKey;
            return this;
        }

        public ReceivedSegmentKey build() {
            Preconditions.checkNotNull(segmentationKey, "SegmentationKey is required");
            Preconditions.checkNotNull(segmentKey, "SegmentKey is required");
            return new ReceivedSegmentKey(segmentationKey, segmentKey);
        }

    }

}
