package ru.yandex.intranet.d.services.operations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Received updated provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedUpdatedProvision {

    private final List<ReceivedProvision> provisions;
    private final Long accountVersion;
    private final ReceivedAccountsSpaceKey accountsSpaceKey;

    public ReceivedUpdatedProvision(List<ReceivedProvision> provisions, Long accountVersion,
                                    ReceivedAccountsSpaceKey accountsSpaceKey) {
        this.provisions = provisions;
        this.accountVersion = accountVersion;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ReceivedProvision> getProvisions() {
        return provisions;
    }

    public Optional<Long> getAccountVersion() {
        return Optional.ofNullable(accountVersion);
    }

    public Optional<ReceivedAccountsSpaceKey> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedUpdatedProvision that = (ReceivedUpdatedProvision) o;
        return Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountVersion, that.accountVersion) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provisions, accountVersion, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "ReceivedUpdatedProvision{" +
                "provisions=" + provisions +
                ", accountVersion=" + accountVersion +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

    public static final class Builder {

        private final List<ReceivedProvision> provisions = new ArrayList<>();

        private Long accountVersion;
        private ReceivedAccountsSpaceKey accountsSpaceKey;

        private Builder() {
        }

        public Builder addProvision(ReceivedProvision provision) {
            this.provisions.add(provision);
            return this;
        }

        public Builder addProvisions(Collection<? extends ReceivedProvision> provisions) {
            this.provisions.addAll(provisions);
            return this;
        }

        public Builder accountVersion(long accountVersion) {
            this.accountVersion = accountVersion;
            return this;
        }

        public Builder accountsSpaceKey(ReceivedAccountsSpaceKey accountsSpaceKey) {
            this.accountsSpaceKey = accountsSpaceKey;
            return this;
        }

        public ReceivedUpdatedProvision build() {
            return new ReceivedUpdatedProvision(provisions, accountVersion, accountsSpaceKey);
        }

    }

}
