package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Received user id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedUserId {

    private final String passportUid;
    private final String staffLogin;

    public ReceivedUserId(String passportUid, String staffLogin) {
        this.passportUid = passportUid;
        this.staffLogin = staffLogin;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getPassportUid() {
        return Optional.ofNullable(passportUid);
    }

    public Optional<String> getStaffLogin() {
        return Optional.ofNullable(staffLogin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedUserId that = (ReceivedUserId) o;
        return Objects.equals(passportUid, that.passportUid) &&
                Objects.equals(staffLogin, that.staffLogin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(passportUid, staffLogin);
    }

    @Override
    public String toString() {
        return "ReceivedUserId{" +
                "passportUid='" + passportUid + '\'' +
                ", staffLogin='" + staffLogin + '\'' +
                '}';
    }

    public static final class Builder {

        private String passportUid;
        private String staffLogin;

        private Builder() {
        }

        public Builder passportUid(String passportUid) {
            this.passportUid = passportUid;
            return this;
        }

        public Builder staffLogin(String staffLogin) {
            this.staffLogin = staffLogin;
            return this;
        }

        public ReceivedUserId build() {
            return new ReceivedUserId(passportUid, staffLogin);
        }

    }

}
