package ru.yandex.intranet.d.services.operations.model;

import java.util.List;
import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;
import ru.yandex.intranet.d.model.accounts.OperationInProgressModel;

/**
 * Retryable opeartion.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class RetryableOperation {

    private final AccountsQuotasOperationsModel operation;

    /**
     * Две записи в operation_in_progress может быть, если операция задевает два фолдера.
     * (пока такая одна -- перенос аккаунта между фолдерами)
     */
    private final List<OperationInProgressModel> inProgress;

    public RetryableOperation(AccountsQuotasOperationsModel operation, List<OperationInProgressModel> inProgress) {
        this.operation = operation;
        this.inProgress = inProgress;
    }

    public RetryableOperation withOperation(AccountsQuotasOperationsModel operation) {
        return new RetryableOperation(operation, this.inProgress);
    }

    public AccountsQuotasOperationsModel getOperation() {
        return operation;
    }

    public List<OperationInProgressModel> getInProgress() {
        return inProgress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RetryableOperation that = (RetryableOperation) o;
        return Objects.equals(operation, that.operation) &&
                Objects.equals(inProgress, that.inProgress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operation, inProgress);
    }

    @Override
    public String toString() {
        return "RetryableOperation{" +
                "operation=" + operation +
                ", inProgress=" + inProgress +
                '}';
    }

}
