package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Update provision operation post-refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateProvisionOperationPostRefreshContext implements OperationPostRefreshContext {

    private final UpdateProvisionOperationRefreshContext refreshContext;
    private final Result<Response<ValidatedReceivedAccount>> postRefreshResult;

    public UpdateProvisionOperationPostRefreshContext(UpdateProvisionOperationRefreshContext refreshContext,
                                                      Result<Response<ValidatedReceivedAccount>> postRefreshResult) {
        this.refreshContext = refreshContext;
        this.postRefreshResult = postRefreshResult;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return refreshContext.getCommonContext();
    }

    @Override
    public UpdateProvisionOperationPreRefreshContext getPreRefreshContext() {
        return refreshContext.getPreRefreshContext();
    }

    @Override
    public UpdateProvisionOperationRefreshContext getRefreshContext() {
        return refreshContext;
    }

    public Result<Response<ValidatedReceivedAccount>> getPostRefreshResult() {
        return postRefreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionOperationPostRefreshContext that = (UpdateProvisionOperationPostRefreshContext) o;
        return Objects.equals(refreshContext, that.refreshContext) &&
                Objects.equals(postRefreshResult, that.postRefreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(refreshContext, postRefreshResult);
    }

    @Override
    public String toString() {
        return "UpdateProvisionOperationPostRefreshContext{" +
                "refreshContext=" + refreshContext +
                ", postRefreshResult=" + postRefreshResult +
                '}';
    }

}
