package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

/**
 * Update provision operation pre-refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateProvisionOperationPreRefreshContext implements OperationPreRefreshContext {

    private final OperationCommonContext commonContext;
    private final UpdateProvisionContext updateProvisionContext;

    public UpdateProvisionOperationPreRefreshContext(OperationCommonContext commonContext,
                                                     UpdateProvisionContext updateProvisionContext) {
        this.commonContext = commonContext;
        this.updateProvisionContext = updateProvisionContext;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return commonContext;
    }

    public UpdateProvisionContext getUpdateProvisionContext() {
        return updateProvisionContext;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionOperationPreRefreshContext that = (UpdateProvisionOperationPreRefreshContext) o;
        return Objects.equals(commonContext, that.commonContext) &&
                Objects.equals(updateProvisionContext, that.updateProvisionContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(commonContext, updateProvisionContext);
    }

    @Override
    public String toString() {
        return "UpdateProvisionOperationPreRefreshContext{" +
                "commonContext=" + commonContext +
                ", updateProvisionContext=" + updateProvisionContext +
                '}';
    }

}
