package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Update provision operation refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateProvisionOperationRefreshContext implements OperationRefreshContext {

    private final UpdateProvisionOperationPreRefreshContext preRefreshContext;
    private final Result<Response<ReceivedAccount>> refreshResult;

    public UpdateProvisionOperationRefreshContext(UpdateProvisionOperationPreRefreshContext preRefreshContext,
                                                  Result<Response<ReceivedAccount>> refreshResult) {
        this.preRefreshContext = preRefreshContext;
        this.refreshResult = refreshResult;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return preRefreshContext.getCommonContext();
    }

    @Override
    public UpdateProvisionOperationPreRefreshContext getPreRefreshContext() {
        return preRefreshContext;
    }

    public Result<Response<ReceivedAccount>> getRefreshResult() {
        return refreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionOperationRefreshContext that = (UpdateProvisionOperationRefreshContext) o;
        return Objects.equals(preRefreshContext, that.preRefreshContext) &&
                Objects.equals(refreshResult, that.refreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preRefreshContext, refreshResult);
    }

    @Override
    public String toString() {
        return "UpdateProvisionOperationRefreshContext{" +
                "preRefreshContext=" + preRefreshContext +
                ", refreshResult=" + refreshResult +
                '}';
    }

}
