package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Update provision operation retry context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class UpdateProvisionOperationRetryContext implements OperationRetryContext {

    private final UpdateProvisionOperationPostRefreshContext postRefreshContext;
    private final RefreshResult refreshResult;
    private final ValidatedReceivedAccount alreadyUpdatedAccount;
    private final String receivedRefreshError;
    private final RetryResult retryResult;
    private final ReceivedUpdatedProvision updatedAccount;
    private final String receivedRetryError;
    private final PostRetryRefreshResult postRetryRefreshResult;
    private final ReceivedAccount postRetryRefreshedAccount;
    private final String receivedPostRetryRefreshError;
    private final String preGeneratedFolderOpLogId;

    @SuppressWarnings("ParameterNumber")
    public UpdateProvisionOperationRetryContext(UpdateProvisionOperationPostRefreshContext postRefreshContext,
                                                RefreshResult refreshResult,
                                                ValidatedReceivedAccount alreadyUpdatedAccount,
                                                String receivedRefreshError,
                                                RetryResult retryResult,
                                                ReceivedUpdatedProvision updatedAccount,
                                                String receivedRetryError,
                                                PostRetryRefreshResult postRetryRefreshResult,
                                                ReceivedAccount postRetryRefreshedAccount,
                                                String receivedPostRetryRefreshError,
                                                String preGeneratedFolderOpLogId) {
        this.postRefreshContext = postRefreshContext;
        this.refreshResult = refreshResult;
        this.alreadyUpdatedAccount = alreadyUpdatedAccount;
        this.receivedRefreshError = receivedRefreshError;
        this.retryResult = retryResult;
        this.updatedAccount = updatedAccount;
        this.receivedRetryError = receivedRetryError;
        this.postRetryRefreshResult = postRetryRefreshResult;
        this.postRetryRefreshedAccount = postRetryRefreshedAccount;
        this.receivedPostRetryRefreshError = receivedPostRetryRefreshError;
        this.preGeneratedFolderOpLogId = preGeneratedFolderOpLogId;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return postRefreshContext.getCommonContext();
    }

    @Override
    public UpdateProvisionOperationPreRefreshContext getPreRefreshContext() {
        return postRefreshContext.getPreRefreshContext();
    }

    @Override
    public UpdateProvisionOperationRefreshContext getRefreshContext() {
        return postRefreshContext.getRefreshContext();
    }

    @Override
    public UpdateProvisionOperationPostRefreshContext getPostRefreshContext() {
        return postRefreshContext;
    }

    public RefreshResult getRefreshResult() {
        return refreshResult;
    }

    public Optional<ValidatedReceivedAccount> getAlreadyUpdatedAccount() {
        return Optional.ofNullable(alreadyUpdatedAccount);
    }

    public Optional<String> getReceivedRefreshError() {
        return Optional.ofNullable(receivedRefreshError);
    }

    @Override
    public Optional<RetryResult> getRetryResult() {
        return Optional.ofNullable(retryResult);
    }

    public Optional<ReceivedUpdatedProvision> getUpdatedAccount() {
        return Optional.ofNullable(updatedAccount);
    }

    public Optional<String> getReceivedRetryError() {
        return Optional.ofNullable(receivedRetryError);
    }

    public Optional<PostRetryRefreshResult> getPostRetryRefreshResult() {
        return Optional.ofNullable(postRetryRefreshResult);
    }

    public Optional<ReceivedAccount> getPostRetryRefreshedAccount() {
        return Optional.ofNullable(postRetryRefreshedAccount);
    }

    public Optional<String> getReceivedPostRetryRefreshError() {
        return Optional.ofNullable(receivedPostRetryRefreshError);
    }

    public String getPreGeneratedFolderOpLogId() {
        return preGeneratedFolderOpLogId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionOperationRetryContext that = (UpdateProvisionOperationRetryContext) o;
        return Objects.equals(postRefreshContext, that.postRefreshContext) &&
                refreshResult == that.refreshResult &&
                Objects.equals(alreadyUpdatedAccount, that.alreadyUpdatedAccount) &&
                Objects.equals(receivedRefreshError, that.receivedRefreshError) &&
                retryResult == that.retryResult &&
                Objects.equals(updatedAccount, that.updatedAccount) &&
                Objects.equals(receivedRetryError, that.receivedRetryError) &&
                postRetryRefreshResult == that.postRetryRefreshResult &&
                Objects.equals(postRetryRefreshedAccount, that.postRetryRefreshedAccount) &&
                Objects.equals(receivedPostRetryRefreshError, that.receivedPostRetryRefreshError) &&
                Objects.equals(preGeneratedFolderOpLogId, that.preGeneratedFolderOpLogId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(postRefreshContext, refreshResult, alreadyUpdatedAccount, receivedRefreshError,
                retryResult, updatedAccount, receivedRetryError, postRetryRefreshResult, postRetryRefreshedAccount,
                receivedPostRetryRefreshError, preGeneratedFolderOpLogId);
    }

    @Override
    public String toString() {
        return "UpdateProvisionOperationRetryContext{" +
                "postRefreshContext=" + postRefreshContext +
                ", refreshResult=" + refreshResult +
                ", alreadyUpdatedAccount=" + alreadyUpdatedAccount +
                ", receivedRefreshError='" + receivedRefreshError + '\'' +
                ", retryResult=" + retryResult +
                ", updatedAccount=" + updatedAccount +
                ", receivedRetryError='" + receivedRetryError + '\'' +
                ", postRetryRefreshResult=" + postRetryRefreshResult +
                ", postRetryRefreshedAccount=" + postRetryRefreshedAccount +
                ", receivedPostRetryRefreshError='" + receivedPostRetryRefreshError + '\'' +
                ", preGeneratedFolderOpLogId='" + preGeneratedFolderOpLogId + '\'' +
                '}';
    }

}
