package ru.yandex.intranet.d.services.operations.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Validated received last update.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedReceivedLastUpdate {

    private final Instant timestamp;
    private final UserModel author;
    private final String operationId;
    private final AccountsQuotasOperationsModel operation;

    public ValidatedReceivedLastUpdate(Instant timestamp,
                                       UserModel author,
                                       String operationId,
                                       AccountsQuotasOperationsModel operation) {
        this.timestamp = timestamp;
        this.author = author;
        this.operationId = operationId;
        this.operation = operation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public Optional<UserModel> getAuthor() {
        return Optional.ofNullable(author);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    public Optional<AccountsQuotasOperationsModel> getOperation() {
        return Optional.ofNullable(operation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedReceivedLastUpdate that = (ValidatedReceivedLastUpdate) o;
        return Objects.equals(timestamp, that.timestamp) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(operation, that.operation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timestamp, author, operationId, operation);
    }

    @Override
    public String toString() {
        return "ValidatedReceivedLastUpdate{" +
                "timestamp=" + timestamp +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", operation=" + operation +
                '}';
    }

    public static final class Builder {

        private Instant timestamp;
        private UserModel author;
        private String operationId;
        private AccountsQuotasOperationsModel operation;

        private Builder() {
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder author(UserModel author) {
            this.author = author;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder operation(AccountsQuotasOperationsModel operation) {
            this.operation = operation;
            return this;
        }

        public ValidatedReceivedLastUpdate build() {
            return new ValidatedReceivedLastUpdate(timestamp, author, operationId, operation);
        }

    }

}
