package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.model.accounts.AccountSpaceModel

data class ValidatedReceivedMoveProvision(
    val sourceProvisions: List<ValidatedReceivedProvision>,
    val destinationProvisions: List<ValidatedReceivedProvision>,
    val accountSpace: AccountSpaceModel?,
    val sourceAccountVersion: Long?,
    val destinationAccountVersion: Long?,
) {

    companion object {
        @JvmStatic
        fun builder() = Builder()
    }

    data class Builder(
        val sourceProvisions: MutableList<ValidatedReceivedProvision> = mutableListOf(),
        val destinationProvisions: MutableList<ValidatedReceivedProvision> = mutableListOf(),
        var accountSpace: AccountSpaceModel? = null,
        var sourceAccountVersion: Long? = null,
        var destinationAccountVersion: Long? = null,
    ) {
        fun addSourceProvision(validatedReceivedProvision: ValidatedReceivedProvision) = apply {
            sourceProvisions += validatedReceivedProvision
        }

        fun addDestinationProvision(validatedReceivedProvision: ValidatedReceivedProvision) = apply {
            destinationProvisions += validatedReceivedProvision
        }

        fun accountSpace(accountSpace: AccountSpaceModel) = apply {
            this.accountSpace = accountSpace
        }

        fun sourceAccountVersion(sourceAccountVersion: Long) = apply {
            this.sourceAccountVersion = sourceAccountVersion
        }

        fun destinationAccountVersion(destinationAccountVersion: Long) = apply {
            this.destinationAccountVersion = destinationAccountVersion
        }

        fun build() = ValidatedReceivedMoveProvision(
            sourceProvisions, destinationProvisions, accountSpace, sourceAccountVersion, destinationAccountVersion
        )
    }
}
