package ru.yandex.intranet.d.services.operations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;

/**
 * Validated received updated provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedReceivedUpdatedProvision {

    private final List<ValidatedReceivedProvision> provisions;
    private final Long accountVersion;
    private final AccountSpaceModel accountsSpace;

    public ValidatedReceivedUpdatedProvision(List<ValidatedReceivedProvision> provisions,
                                             Long accountVersion,
                                             AccountSpaceModel accountsSpace) {
        this.provisions = provisions;
        this.accountVersion = accountVersion;
        this.accountsSpace = accountsSpace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ValidatedReceivedProvision> getProvisions() {
        return provisions;
    }

    public Optional<Long> getAccountVersion() {
        return Optional.ofNullable(accountVersion);
    }

    public Optional<AccountSpaceModel> getAccountsSpace() {
        return Optional.ofNullable(accountsSpace);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedReceivedUpdatedProvision that = (ValidatedReceivedUpdatedProvision) o;
        return Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountVersion, that.accountVersion) &&
                Objects.equals(accountsSpace, that.accountsSpace);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provisions, accountVersion, accountsSpace);
    }

    @Override
    public String toString() {
        return "ValidatedReceivedUpdatedProvision{" +
                "provisions=" + provisions +
                ", accountVersion=" + accountVersion +
                ", accountsSpace=" + accountsSpace +
                '}';
    }

    public static final class Builder {

        private final List<ValidatedReceivedProvision> provisions = new ArrayList<>();

        private Long accountVersion;
        private AccountSpaceModel accountsSpace;

        private Builder() {
        }

        public Builder addProvision(ValidatedReceivedProvision provision) {
            this.provisions.add(provision);
            return this;
        }

        public Builder addProvisions(Collection<? extends ValidatedReceivedProvision> provisions) {
            this.provisions.addAll(provisions);
            return this;
        }

        public Builder accountVersion(Long accountVersion) {
            this.accountVersion = accountVersion;
            return this;
        }

        public Builder accountsSpace(AccountSpaceModel accountsSpace) {
            this.accountsSpace = accountsSpace;
            return this;
        }

        public ValidatedReceivedUpdatedProvision build() {
            return new ValidatedReceivedUpdatedProvision(provisions, accountVersion, accountsSpace);
        }

    }

}
