package ru.yandex.intranet.d.services.providers;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import ru.yandex.intranet.d.util.MdcTaskDecorator;

/**
 * Configuration for {@link ProvidersService}
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Configuration
public class ProviderServiceConfiguration {

    @Bean
    public ThreadPoolTaskExecutor putProvisionsAsQuotasExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setQueueCapacity(10);
        executor.setMaxPoolSize(1);
        executor.setCorePoolSize(1);
        executor.setDaemon(true);
        executor.setThreadNamePrefix("put-provisions-as-quotas-pool-");
        executor.setTaskDecorator(new MdcTaskDecorator());
        return executor;
    }
}
