package ru.yandex.intranet.d.services.provisions;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Provisions by account continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvisionsByAccountContinuationToken {

    private final String resourceId;

    @JsonCreator
    public ProvisionsByAccountContinuationToken(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return resourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionsByAccountContinuationToken that = (ProvisionsByAccountContinuationToken) o;
        return Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId);
    }

    @Override
    public String toString() {
        return "ProvisionsByAccountContinuationToken{" +
                "resourceId='" + resourceId + '\'' +
                '}';
    }

}
