package ru.yandex.intranet.d.services.quotas;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Expanded provision result.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedProvisionResult {

    private final List<ResourceModel> requestResourceModels;
    private final List<AccountsQuotasModel> actualUpdatedQuotas;
    private final List<AccountsQuotasModel> currentActualQuotas;
    private final Map<String, ResourceModel> allResourceByIdMap;
    private final Map<String, UnitsEnsembleModel> ensembleModelByIdMap;
    private final AccountModel currentAccount;

    public ExpandedProvisionResult(List<ResourceModel> requestResourceModels,
                                   List<AccountsQuotasModel> actualUpdatedQuotas,
                                   List<AccountsQuotasModel> currentActualQuotas,
                                   Map<String, ResourceModel> allResourceByIdMap,
                                   Map<String, UnitsEnsembleModel> ensembleModelByIdMap,
                                   AccountModel currentAccount) {
        this.requestResourceModels = requestResourceModels;
        this.actualUpdatedQuotas = actualUpdatedQuotas;
        this.currentActualQuotas = currentActualQuotas;
        this.allResourceByIdMap = allResourceByIdMap;
        this.ensembleModelByIdMap = ensembleModelByIdMap;
        this.currentAccount = currentAccount;
    }

    public List<ResourceModel> getRequestResourceModels() {
        return requestResourceModels;
    }

    public List<AccountsQuotasModel> getActualUpdatedQuotas() {
        return actualUpdatedQuotas;
    }

    public List<AccountsQuotasModel> getCurrentActualQuotas() {
        return currentActualQuotas;
    }

    public Map<String, ResourceModel> getAllResourceByIdMap() {
        return allResourceByIdMap;
    }

    public Map<String, UnitsEnsembleModel> getEnsembleModelByIdMap() {
        return ensembleModelByIdMap;
    }

    public AccountModel getCurrentAccount() {
        return currentAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedProvisionResult that = (ExpandedProvisionResult) o;
        return Objects.equals(requestResourceModels, that.requestResourceModels) &&
                Objects.equals(actualUpdatedQuotas, that.actualUpdatedQuotas) &&
                Objects.equals(currentActualQuotas, that.currentActualQuotas) &&
                Objects.equals(allResourceByIdMap, that.allResourceByIdMap) &&
                Objects.equals(ensembleModelByIdMap, that.ensembleModelByIdMap) &&
                Objects.equals(currentAccount, that.currentAccount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestResourceModels, actualUpdatedQuotas, currentActualQuotas, allResourceByIdMap,
                ensembleModelByIdMap, currentAccount);
    }

    @Override
    public String toString() {
        return "ExpandedProvisionResult{" +
                "requestResourceModels=" + requestResourceModels +
                ", actualUpdatedQuotas=" + actualUpdatedQuotas +
                ", currentActualQuotas=" + currentActualQuotas +
                ", allResourceByIdMap=" + allResourceByIdMap +
                ", ensembleModelByIdMap=" + ensembleModelByIdMap +
                ", currentAccount=" + currentAccount +
                '}';
    }

}
