package ru.yandex.intranet.d.services.quotas;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Quotas with resources and units ensembles.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedQuotas<T> {

    private final T quotas;
    private final Map<String, ResourceModel> resources;
    private final Map<String, UnitsEnsembleModel> unitsEnsembles;

    public ExpandedQuotas(T quotas,
                          Map<String, ResourceModel> resources,
                          Map<String, UnitsEnsembleModel> unitsEnsembles) {
        this.quotas = quotas;
        this.resources = resources;
        this.unitsEnsembles = unitsEnsembles;
    }

    public T getQuotas() {
        return quotas;
    }

    public Map<String, ResourceModel> getResources() {
        return resources;
    }

    public Map<String, UnitsEnsembleModel> getUnitsEnsembles() {
        return unitsEnsembles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedQuotas<?> that = (ExpandedQuotas<?>) o;
        return Objects.equals(quotas, that.quotas) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(unitsEnsembles, that.unitsEnsembles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotas, resources, unitsEnsembles);
    }

    @Override
    public String toString() {
        return "ExpandedQuotas{" +
                "quotas=" + quotas +
                ", resources=" + resources +
                ", unitsEnsembles=" + unitsEnsembles +
                '}';
    }

}
