package ru.yandex.intranet.d.services.quotas;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import ru.yandex.intranet.d.web.model.folders.front.FolderPermission;
import ru.yandex.intranet.d.web.model.folders.front.ProviderPermission;

/**
 * Folders permission collection.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FoldersPermissionsCollection {

    private final Map<String, Set<FolderPermission>> folderPermissions;
    private final Map<String, Map<String, Set<ProviderPermission>>> folderProviderPermissions;

    public FoldersPermissionsCollection(Map<String, Set<FolderPermission>> folderPermissions,
                                        Map<String, Map<String, Set<ProviderPermission>>> folderProviderPermissions) {
        this.folderPermissions = folderPermissions;
        this.folderProviderPermissions = folderProviderPermissions;
    }

    public Map<String, Set<FolderPermission>> getFolderPermissions() {
        return folderPermissions;
    }

    public Map<String, Map<String, Set<ProviderPermission>>> getFolderProviderPermissions() {
        return folderProviderPermissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FoldersPermissionsCollection that = (FoldersPermissionsCollection) o;
        return Objects.equals(folderPermissions, that.folderPermissions) &&
                Objects.equals(folderProviderPermissions, that.folderProviderPermissions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderPermissions, folderProviderPermissions);
    }

    @Override
    public String toString() {
        return "FoldersPermissionsCollection{" +
                "folderPermissions=" + folderPermissions +
                ", folderProviderPermissions=" + folderProviderPermissions +
                '}';
    }

}
