package ru.yandex.intranet.d.services.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Provision operation failure metadata.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Provision operation failure metadata.")
public class ProvisionOperationFailureMeta {

    private final String operationId;

    @JsonCreator
    public ProvisionOperationFailureMeta(String operationId) {
        this.operationId = operationId;
    }

    @Schema(description = "Unique operation id.", required = true)
    public String getOperationId() {
        return operationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionOperationFailureMeta that = (ProvisionOperationFailureMeta) o;
        return Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId);
    }

    @Override
    public String toString() {
        return "ProvisionOperationFailureMeta{" +
                "operationId='" + operationId + '\'' +
                '}';
    }

}
