package ru.yandex.intranet.d.services.quotas;

import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.web.model.quotas.UpdateProvisionsAnswerDto;

/**
 * Provision operation result.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ProvisionOperationResult {

    private final UpdateProvisionsAnswerDto result;
    private final ProvisionOperationResultStatus status;
    private final String operationId;
    private final ExpandedProvisionResult expandedProvisionResult;

    private ProvisionOperationResult(UpdateProvisionsAnswerDto result,
                                     ProvisionOperationResultStatus status,
                                     String operationId,
                                     ExpandedProvisionResult expandedProvisionResult) {
        this.result = result;
        this.status = status;
        this.operationId = operationId;
        this.expandedProvisionResult = expandedProvisionResult;
    }

    public static ProvisionOperationResult success(UpdateProvisionsAnswerDto result, String operationId,
                                                   ExpandedProvisionResult expandedProvisionResult) {
        return new ProvisionOperationResult(result, ProvisionOperationResultStatus.SUCCESS, operationId,
                expandedProvisionResult);
    }

    public static ProvisionOperationResult inProgress(String operationId) {
        return new ProvisionOperationResult(null, ProvisionOperationResultStatus.IN_PROGRESS, operationId, null);
    }

    public Optional<UpdateProvisionsAnswerDto> getResult() {
        return Optional.ofNullable(result);
    }

    public ProvisionOperationResultStatus getStatus() {
        return status;
    }

    public String getOperationId() {
        return operationId;
    }

    public Optional<ExpandedProvisionResult> getExpandedProvisionResult() {
        return Optional.ofNullable(expandedProvisionResult);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionOperationResult that = (ProvisionOperationResult) o;
        return Objects.equals(result, that.result) &&
                status == that.status &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(expandedProvisionResult, that.expandedProvisionResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(result, status, operationId, expandedProvisionResult);
    }

    @Override
    public String toString() {
        return "ProvisionOperationResult{" +
                "result=" + result +
                ", status=" + status +
                ", operationId='" + operationId + '\'' +
                ", expandedProvisionResult=" + expandedProvisionResult +
                '}';
    }

}
