package ru.yandex.intranet.d.services.quotas;

import java.util.Objects;

/**
 * Provision operation state.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ProvisionOperationState {

    private final QuotasProvisionAnswerBuilder builder;
    private final boolean shortCircuit;

    private ProvisionOperationState(QuotasProvisionAnswerBuilder builder, boolean shortCircuit) {
        this.builder = builder;
        this.shortCircuit = shortCircuit;
    }

    public static ProvisionOperationState continued(QuotasProvisionAnswerBuilder builder) {
        return new ProvisionOperationState(builder, false);
    }

    public static ProvisionOperationState shortCircuited(QuotasProvisionAnswerBuilder builder) {
        return new ProvisionOperationState(builder, true);
    }

    public QuotasProvisionAnswerBuilder getBuilder() {
        return builder;
    }

    public boolean isShortCircuit() {
        return shortCircuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionOperationState that = (ProvisionOperationState) o;
        return shortCircuit == that.shortCircuit &&
                Objects.equals(builder, that.builder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(builder, shortCircuit);
    }

    @Override
    public String toString() {
        return "ProvisionOperationState{" +
                "builder=" + builder +
                ", shortCircuit=" + shortCircuit +
                '}';
    }

}
