package ru.yandex.intranet.d.services.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Quota continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QuotaContinuationToken {

    private final String providerId;
    private final String resourceId;

    @JsonCreator
    public QuotaContinuationToken(@JsonProperty("providerId") String providerId,
                                  @JsonProperty("resourceId") String resourceId) {
        this.providerId = providerId;
        this.resourceId = resourceId;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getResourceId() {
        return resourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaContinuationToken that = (QuotaContinuationToken) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, resourceId);
    }

    @Override
    public String toString() {
        return "QuotaContinuationToken{" +
                "providerId='" + providerId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                '}';
    }

}
