package ru.yandex.intranet.d.services.quotas;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * QuotaSums.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 20-02-2021
 */
public class QuotaSums {
    private final String resourceId;
    private Long quota = null;
    private Long balance = null;
    private Long providedQuota = null;
    private Long allocatedQuota;
    private Long frozenQuota;

    private QuotaSums(String resourceId) {
        this.resourceId = resourceId;
    }

    public static QuotaSums from(QuotaModel model) {
        QuotaSums quotaSums = new QuotaSums(model.getResourceId());
        quotaSums.setQuota(model.getQuota());
        quotaSums.setBalance(model.getBalance());
        quotaSums.setFrozenQuota(model.getFrozenQuota());
        return quotaSums;
    }

    public static QuotaSums from(AccountsQuotasModel model, QuotaModel folderQuota) {
        QuotaSums quotaSums = new QuotaSums(model.getResourceId());
        if (folderQuota != null) {
            quotaSums.setBalance(folderQuota.getBalance());
        }
        quotaSums.setProvidedQuota(model.getProvidedQuota());
        quotaSums.setAllocatedQuota(model.getAllocatedQuota());
        return quotaSums;
    }

    public void add(AccountsQuotasModel model) {
        if (model.getProvidedQuota() != null) {
            providedQuota = (providedQuota != null ? providedQuota : 0L) + model.getProvidedQuota();
        }
        if (model.getAllocatedQuota() != null) {
            allocatedQuota = (allocatedQuota != null ? allocatedQuota : 0L) + model.getAllocatedQuota();
        }
    }

    public String getResourceId() {
        return resourceId;
    }

    public Long getQuota() {
        return quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getProvidedQuota() {
        return providedQuota;
    }

    public void setProvidedQuota(long providedQuota) {
        this.providedQuota = providedQuota;
    }

    public Long getAllocatedQuota() {
        return allocatedQuota;
    }

    public void setAllocatedQuota(Long allocatedQuota) {
        this.allocatedQuota = allocatedQuota;
    }

    public Long getFrozenQuota() {
        return frozenQuota;
    }

    public void setFrozenQuota(Long frozenQuota) {
        this.frozenQuota = frozenQuota;
    }
}
