package ru.yandex.intranet.d.services.quotas;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.transfers.TransferRequestModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * List transfers with quota move
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public final class QuotasMoveStatisticResult {
    private final List<TransferRequestModel> transfersCreated;
    private final List<TransferRequestModel> transfersApplied;
    private final Map<String, ResourceModel> resourceById;
    private final Map<String, UnitsEnsembleModel> unitsEnsembleById;

    public QuotasMoveStatisticResult(List<TransferRequestModel> transfersCreated,
                                     List<TransferRequestModel> transfersApplied,
                                     Map<String, ResourceModel> resourceById,
                                     Map<String, UnitsEnsembleModel> unitsEnsembleById) {
        this.transfersCreated = transfersCreated;
        this.transfersApplied = transfersApplied;
        this.resourceById = resourceById;
        this.unitsEnsembleById = unitsEnsembleById;
    }

    public List<TransferRequestModel> getTransfersCreated() {
        return transfersCreated;
    }

    public List<TransferRequestModel> getTransfersApplied() {
        return transfersApplied;
    }

    public Map<String, ResourceModel> getResourceById() {
        return resourceById;
    }

    public Map<String, UnitsEnsembleModel> getUnitsEnsembleById() {
        return unitsEnsembleById;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotasMoveStatisticResult that = (QuotasMoveStatisticResult) o;
        return Objects.equals(transfersCreated, that.transfersCreated)
                && Objects.equals(transfersApplied, that.transfersApplied)
                && Objects.equals(resourceById, that.resourceById)
                && Objects.equals(unitsEnsembleById, that.unitsEnsembleById);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transfersCreated, transfersApplied, resourceById, unitsEnsembleById);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
