package ru.yandex.intranet.d.services.resources;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;

/**
 * ExpandedResourcesAccountsSpace.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 22.01.2021
 */
public final class ExpandedAccountsSpaces<T> {
    private final T accountsSpaces;
    private final Map<String, ResourceSegmentationModel> segmentations;
    private final Map<String, ResourceSegmentModel> segments;

    public ExpandedAccountsSpaces(
            T accountsSpaces,
            Map<String, ResourceSegmentationModel> segmentations,
            Map<String, ResourceSegmentModel> segments
    ) {
        this.accountsSpaces = accountsSpaces;
        this.segmentations = segmentations;
        this.segments = segments;
    }

    public T getAccountsSpaces() {
        return accountsSpaces;
    }

    public Map<String, ResourceSegmentationModel> getSegmentations() {
        return segmentations;
    }

    public Map<String, ResourceSegmentModel> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedAccountsSpaces<?> that = (ExpandedAccountsSpaces<?>) o;
        return Objects.equals(accountsSpaces, that.accountsSpaces) && Objects.equals(segmentations,
                that.segmentations) && Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountsSpaces, segmentations, segments);
    }

    @Override
    public String toString() {
        return "ExpandedAccountsSpaces{" +
                "accountsSpaces=" + accountsSpaces +
                ", segmentations=" + segmentations +
                ", segments=" + segments +
                '}';
    }
}
