package ru.yandex.intranet.d.services.resources;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;
import ru.yandex.intranet.d.model.resources.types.ResourceTypeModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Resources with segmentation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedResources<T> {

    private final T resources;
    private final Map<String, ResourceTypeModel> resourceTypes;
    private final Map<String, ResourceSegmentationModel> resourceSegmentations;
    private final Map<String, ResourceSegmentModel> resourceSegments;
    private final Map<String, UnitsEnsembleModel> unitsEnsembles;

    public ExpandedResources(T resources, Map<String, ResourceTypeModel> resourceTypes,
                             Map<String, ResourceSegmentationModel> resourceSegmentations,
                             Map<String, ResourceSegmentModel> resourceSegments,
                             Map<String, UnitsEnsembleModel> unitsEnsembles) {
        this.resources = resources;
        this.resourceTypes = resourceTypes;
        this.resourceSegmentations = resourceSegmentations;
        this.resourceSegments = resourceSegments;
        this.unitsEnsembles = unitsEnsembles;
    }

    public T getResources() {
        return resources;
    }

    public Map<String, ResourceTypeModel> getResourceTypes() {
        return resourceTypes;
    }

    public Map<String, ResourceSegmentationModel> getResourceSegmentations() {
        return resourceSegmentations;
    }

    public Map<String, ResourceSegmentModel> getResourceSegments() {
        return resourceSegments;
    }

    public Map<String, UnitsEnsembleModel> getUnitsEnsembles() {
        return unitsEnsembles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedResources<?> that = (ExpandedResources<?>) o;
        return Objects.equals(resources, that.resources) &&
                Objects.equals(resourceTypes, that.resourceTypes) &&
                Objects.equals(resourceSegmentations, that.resourceSegmentations) &&
                Objects.equals(resourceSegments, that.resourceSegments) &&
                Objects.equals(unitsEnsembles, that.unitsEnsembles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resources, resourceTypes, resourceSegmentations, resourceSegments, unitsEnsembles);
    }

    @Override
    public String toString() {
        return "ExpandedResources{" +
                "resources=" + resources +
                ", resourceTypes=" + resourceTypes +
                ", resourceSegmentations=" + resourceSegmentations +
                ", resourceSegments=" + resourceSegments +
                ", unitsEnsembles=" + unitsEnsembles +
                '}';
    }

}
