package ru.yandex.intranet.d.services.resources;

import java.util.Objects;
import java.util.function.Predicate;

import ru.yandex.intranet.d.model.resources.ResourceModel;

public class ResourceFilterParameters {
    private final boolean withReadOnly;
    private final boolean withUnmanaged;

    private ResourceFilterParameters(boolean withReadOnly, boolean withUnmanaged) {
        this.withReadOnly = withReadOnly;
        this.withUnmanaged = withUnmanaged;
    }

    public boolean isWithReadOnly() {
        return withReadOnly;
    }

    public boolean isWithUnmanaged() {
        return withUnmanaged;
    }

    public Predicate<ResourceModel> getPredicate() {
        return (resourceModel) -> (withReadOnly || !resourceModel.isReadOnly())
                && (withUnmanaged || resourceModel.isManaged());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceFilterParameters that = (ResourceFilterParameters) o;
        return withReadOnly == that.withReadOnly && withUnmanaged == that.withUnmanaged;
    }

    @Override
    public int hashCode() {
        return Objects.hash(withReadOnly, withUnmanaged);
    }

    @Override
    public String toString() {
        return "FilterParameters{" +
                "withReadOnly=" + withReadOnly +
                ", withUnmanaged=" + withUnmanaged +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean withReadOnly;
        private Boolean withUnmanaged;

        public Builder withReadOnly(Boolean withReadOnly) {
            this.withReadOnly = withReadOnly;
            return this;
        }

        public Builder withUnmanaged(Boolean withUnmanaged) {
            this.withUnmanaged = withUnmanaged;
            return this;
        }

        public ResourceFilterParameters build() {
            return new ResourceFilterParameters(
                    Objects.requireNonNull(withReadOnly),
                    Objects.requireNonNull(withUnmanaged)
            );
        }
    }
}
