package ru.yandex.intranet.d.services.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.resources.ResourceModel;

/**
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
@Component
public class ResourceTreeUtils {

    public SelectionResourceTreeNode groupToResourceTree(
            List<ResourceModel> resourceModels, String[] segmentationIdsInOrder, int i) {
        if (resourceModels.isEmpty()) {
            return new SelectionResourceTreeNode(null, null, null);
        }

        // if no more segmentations, then it's leaf node, return resources
        if (i == segmentationIdsInOrder.length) {
            return new SelectionResourceTreeNode(null, null, resourceModels);
        }

        // get next segmentation id by order
        String segmentationId = segmentationIdsInOrder[i];

        Map<String, List<ResourceModel>> resourcesBySegmentId = new HashMap<>();
        List<ResourceModel> resourcesWithoutSegmentation = new ArrayList<>();
        resourceModels.forEach(resourceModel -> resourceModel.getSegments().stream()
                .filter(segment -> segment.getSegmentationId().equals(segmentationId))
                .findFirst()
                .ifPresentOrElse(segment -> resourcesBySegmentId.computeIfAbsent(segment.getSegmentId(),
                                k -> new ArrayList<>()).add(resourceModel),
                        () -> resourcesWithoutSegmentation.add(resourceModel))
        );

        // if no resources with current segmentation, skip it
        if (resourcesBySegmentId.isEmpty()) {
            return groupToResourceTree(resourceModels, segmentationIdsInOrder, i + 1);
        }

        Map<String, SelectionResourceTreeNode> childrenBySegmentId = new HashMap<>();
        resourcesBySegmentId.forEach((segmentId, resources) ->
                childrenBySegmentId.put(segmentId, groupToResourceTree(resources, segmentationIdsInOrder, i + 1)));

        // add resources without current segmentation, if presence
        if (!resourcesWithoutSegmentation.isEmpty()) {
            childrenBySegmentId.put(SelectionResourceTreeNode.EMPTY_SEGMENT_PLACEHOLDER,
                    groupToResourceTree(resourcesWithoutSegmentation, segmentationIdsInOrder, i + 1));
        }

        return new SelectionResourceTreeNode(childrenBySegmentId, segmentationId, null);
    }

}
