package ru.yandex.intranet.d.services.resources;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.resources.ResourceModel;

/**
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
public class SelectionResourceTreeNode {
    public static final String EMPTY_SEGMENT_PLACEHOLDER = "empty";
    private final Map<String, SelectionResourceTreeNode> childrenBySegmentId;
    private final String segmentationId;
    private final List<ResourceModel> resources;

    public SelectionResourceTreeNode(Map<String, SelectionResourceTreeNode> childrenBySegmentId,
                                     String segmentationId,
                                     List<ResourceModel> resources) {
        this.childrenBySegmentId = childrenBySegmentId;
        this.segmentationId = segmentationId;
        this.resources = resources;
    }

    public Map<String, SelectionResourceTreeNode> getChildrenBySegmentId() {
        return childrenBySegmentId;
    }

    public String getSegmentationId() {
        return segmentationId;
    }

    public List<ResourceModel> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelectionResourceTreeNode that = (SelectionResourceTreeNode) o;
        return Objects.equals(childrenBySegmentId, that.childrenBySegmentId)
                && Objects.equals(segmentationId, that.segmentationId) && Objects.equals(resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(childrenBySegmentId, segmentationId, resources);
    }

    @Override
    public String toString() {
        return "SelectionResourceTreeNode{" +
                "childrenBySegmentId=" + childrenBySegmentId +
                ", segmentationId='" + segmentationId + '\'' +
                ", resources=" + resources +
                '}';
    }
}
