package ru.yandex.intranet.d.services.resources;

import java.util.Map;

import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;

public class SelectionTreeNode {
    private final String segmentationName;
    private final Map<String, SelectionTreeNode> childrenBySegmentId;
    private final AccountSpaceModel value;
    private static final SelectionTreeNode EMPTY = new SelectionTreeNode(null, null, null);

    private SelectionTreeNode(String segmentationName, Map<String, SelectionTreeNode> childrenBySegmentId,
                              AccountSpaceModel value) {
        this.segmentationName = segmentationName;
        this.childrenBySegmentId = childrenBySegmentId;
        this.value = value;
    }

    public String getSegmentationName() {
        return segmentationName;
    }

    public Map<String, SelectionTreeNode> getChildrenBySegmentId() {
        return childrenBySegmentId;
    }

    public AccountSpaceModel getValue() {
        return value;
    }

    public static SelectionTreeNode empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String segmentationName;
        private Map<String, SelectionTreeNode> childrenBySegmentId;
        private AccountSpaceModel value;

        public Builder segmentationName(String segmentationName) {
            this.segmentationName = segmentationName;
            return this;
        }

        public Builder childrenBySegmentId(Map<String, SelectionTreeNode> childrenBySegmentId) {
            this.childrenBySegmentId = childrenBySegmentId;
            return this;
        }

        public Builder value(AccountSpaceModel value) {
            this.value = value;
            return this;
        }

        public SelectionTreeNode build() {
            return new SelectionTreeNode(segmentationName, childrenBySegmentId, value);
        }
    }
}
