package ru.yandex.intranet.d.services.resources

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.web.model.FeatureStateDto
import ru.yandex.intranet.d.web.model.ResourceDto
import ru.yandex.intranet.d.web.model.resources.ResourceSegmentationSegmentDto
import ru.yandex.intranet.d.web.model.resources.ResourceUnitsDto

@Schema(description = "Resource + resource type names and sorting order.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class SelectionTreeResourceDto @JsonCreator constructor(
    @get:Schema(description = "Unique id of resource.", required = true)
    val id: String,
    @get:Schema(description = "Provider id.", required = true)
    val providerId: String,
    @get:Schema(description = "Description of resource.", required = true)
    val specification: String,
    @get:Schema(description = "Display name of resource.", required = true)
    val displayName: String,
    @get:Schema(description = "Default unit name.")
    val defaultUnit: String?,
    @get:Schema(description = "Default unit id.")
    val defaultUnitId: String?,
    @get:Schema(description = "Deleted flag.", required = true)
    val deleted: Boolean,
    @get:Schema(description = "Resource type id.", required = true)
    val resourceTypeId: String,
    @get:Schema(description = "Units ensemble id.", required = true)
    val unitsEnsembleId: String,
    @get:Schema(description = "Accounts space id.")
    val accountsSpacesId: String?,
    @get:Schema(description = "'Managed' flag.", required = true)
    val managed: Boolean,
    @get:Schema(description = "'Read only' flag.", required = true)
    val readOnly: Boolean,
    @get:Schema(description = "'Virtual' flag.", required = true)
    val virtual: Boolean,
    @get:Schema(description = "Allowed and default for resource units.", required = true)
    val resourceUnits: ResourceUnitsDto,
    @get:Schema(description = "Resource segments IDs by segmentations.", required = true)
    val resourceSegments: Set<ResourceSegmentationSegmentDto>,
    @get:Schema(description = "'Allocated supported' feature state.", required = true)
    val allocatedSupported: FeatureStateDto,
    @get:Schema(description = "Resource type name, en locale.", required = true)
    val resourceTypeNameEn: String,
    @get:Schema(description = "Resource type name, ru locale.", required = true)
    val resourceTypeNameRu: String,
    @get:Schema(description = "Resource type sorting order.")
    val sortingOrder: Long?,
    @get:Schema(description = "Resource type key.", required = true)
    val resourceTypeKey: String,
    @get:Schema(description = "Resource key.", required = true)
    val resourceKey: String
) {
    constructor(
        resourceDto: ResourceDto,
        resourceTypeNameEn: String,
        resourceTypeNameRu: String,
        sortingOrder: Long?,
        resourceTypeKey: String,
        resourceKey: String
    ) : this(
        resourceDto.id,
        resourceDto.providerId,
        resourceDto.specification,
        resourceDto.displayName,
        resourceDto.defaultUnit,
        resourceDto.defaultUnitId,
        resourceDto.isDeleted,
        resourceDto.resourceTypeId,
        resourceDto.unitsEnsembleId,
        resourceDto.accountsSpacesId,
        resourceDto.isManaged,
        resourceDto.isReadOnly,
        resourceDto.isVirtual,
        resourceDto.resourceUnits,
        resourceDto.resourceSegments,
        resourceDto.isAllocatedSupported,
        resourceTypeNameEn,
        resourceTypeNameRu,
        sortingOrder,
        resourceTypeKey,
        resourceKey
    )
}
