package ru.yandex.intranet.d.services.security;

import ru.yandex.intranet.d.model.users.UserModel;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Roles of d users.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 23.10.2020
 */
public enum DRole {
    D_ADMIN(DRoleFunctions.builder()
            .hasRolePredicate(DRole::isDAdmin)
            .hasRoleForProviderPredicate((yaUserDetails, providerId) -> isDAdmin(yaUserDetails))
            .hasRoleForFolderPredicate((yaUserDetails, folderId) -> isDAdmin(yaUserDetails))
            .hasRoleForServicePredicate((yaUserDetails, serviceId) -> isDAdmin(yaUserDetails))
            .build()
    );

    @SuppressWarnings("ImmutableEnumChecker")
    private final DRoleFunctions dRoleFunctions;

    DRole(DRoleFunctions dRoleFunctions) {
        this.dRoleFunctions = dRoleFunctions;
    }

    public boolean hasRole(YaUserDetails yaUserDetails) {
        return dRoleFunctions.getHasRolePredicate().test(yaUserDetails);
    }

    public boolean hasRoleForProvider(YaUserDetails yaUserDetails, String providerId) {
        return dRoleFunctions.getHasRoleForProviderPredicate().apply(yaUserDetails, providerId);
    }

    public boolean hasRoleForFolder(YaUserDetails yaUserDetails, String folderId) {
        return dRoleFunctions.getHasRoleForFolderPredicate().apply(yaUserDetails, folderId);
    }

    public boolean hasRoleForService(YaUserDetails yaUserDetails, long serviceId) {
        return dRoleFunctions.getHasRoleForServicePredicate().apply(yaUserDetails, serviceId);
    }

    private static boolean isDAdmin(YaUserDetails yaUserDetails) {
        return yaUserDetails.getUser().map(UserModel::getDAdmin).orElse(false);
    }
}
