package ru.yandex.intranet.d.services.security;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;

import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * DRoleFunctions used for {@link DRole} enum elements.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 23.10.2020
 */
public final class DRoleFunctions {
    private final Predicate<YaUserDetails> hasRolePredicate;
    private final BiFunction<YaUserDetails, String, Boolean> hasRoleForProviderPredicate;
    private final BiFunction<YaUserDetails, String, Boolean> hasRoleForFolderPredicate;
    private final BiFunction<YaUserDetails, Long, Boolean> hasRoleForServicePredicate;

    private DRoleFunctions(Builder builder) {
        this.hasRolePredicate = builder.hasRolePredicate;
        this.hasRoleForProviderPredicate = builder.hasRoleForProviderPredicate;
        this.hasRoleForFolderPredicate = builder.hasRoleForFolderPredicate;
        this.hasRoleForServicePredicate = builder.hasRoleForServicePredicate;

        Objects.requireNonNull(this.hasRolePredicate, "hasRolePredicate is required.");
        Objects.requireNonNull(this.hasRoleForProviderPredicate, "hasRoleForProviderPredicate is required.");
        Objects.requireNonNull(this.hasRoleForFolderPredicate, "hasRoleForFolderPredicate is required.");
        Objects.requireNonNull(this.hasRoleForServicePredicate, "hasRoleForServicePredicate is required.");
    }

    public Predicate<YaUserDetails> getHasRolePredicate() {
        return hasRolePredicate;
    }

    public BiFunction<YaUserDetails, String, Boolean> getHasRoleForProviderPredicate() {
        return hasRoleForProviderPredicate;
    }

    public BiFunction<YaUserDetails, String, Boolean> getHasRoleForFolderPredicate() {
        return hasRoleForFolderPredicate;
    }

    public BiFunction<YaUserDetails, Long, Boolean> getHasRoleForServicePredicate() {
        return hasRoleForServicePredicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Predicate<YaUserDetails> hasRolePredicate = a -> notSupported();
        private BiFunction<YaUserDetails, String, Boolean> hasRoleForProviderPredicate = (a, b) -> notSupported();
        private BiFunction<YaUserDetails, String, Boolean> hasRoleForFolderPredicate = (a, b) -> notSupported();
        private BiFunction<YaUserDetails, Long, Boolean> hasRoleForServicePredicate = (a, b) -> notSupported();

        public Builder hasRolePredicate(Predicate<YaUserDetails> hasRolePredicate) {
            this.hasRolePredicate = hasRolePredicate;
            return this;
        }

        public Builder hasRoleForProviderPredicate(
                BiFunction<YaUserDetails, String, Boolean> hasRoleForProviderPredicate) {
            this.hasRoleForProviderPredicate = hasRoleForProviderPredicate;
            return this;
        }

        public Builder hasRoleForFolderPredicate(BiFunction<YaUserDetails, String, Boolean> hasRoleForFolderPredicate) {
            this.hasRoleForFolderPredicate = hasRoleForFolderPredicate;
            return this;
        }

        public Builder hasRoleForServicePredicate(BiFunction<YaUserDetails, Long, Boolean> hasRoleForServicePredicate) {
            this.hasRoleForServicePredicate = hasRoleForServicePredicate;
            return this;
        }

        public DRoleFunctions build() {
            return new DRoleFunctions(this);
        }

        private static boolean notSupported() {
            throw new UnsupportedOperationException("This method is unsupported for this role.");
        }
    }
}
