package ru.yandex.intranet.d.services.settings

import org.springframework.stereotype.Component
import ru.yandex.intranet.d.dao.settings.RuntimeSettingsDao
import ru.yandex.intranet.d.datasource.dbSessionRetryable
import ru.yandex.intranet.d.datasource.model.YdbTableClient
import ru.yandex.intranet.d.model.TenantId
import ru.yandex.intranet.d.model.settings.KnownProviders
import ru.yandex.intranet.d.model.settings.RateLimiterSettings
import ru.yandex.intranet.d.model.settings.SettingsKey
import ru.yandex.intranet.d.model.settings.YpUsageSyncSettings
import ru.yandex.intranet.d.model.settings.YtUsageSyncSettings

/**
 * Runtime settings service implementation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
class RuntimeSettingsService(
    private val tableClient: YdbTableClient,
    private val runtimeSettingsDao: RuntimeSettingsDao
) {

    suspend fun getKnownProvidersImmediate(tenantId: TenantId): KnownProviders? {
        return dbSessionRetryable(tableClient) {
            runtimeSettingsDao.get(roStaleSingleRetryableCommit(), tenantId, SettingsKey.KNOWN_PROVIDERS)
        }
    }

    suspend fun getYtUsageSyncSettingsImmediate(tenantId: TenantId): YtUsageSyncSettings? {
        return dbSessionRetryable(tableClient) {
            runtimeSettingsDao.get(roStaleSingleRetryableCommit(), tenantId, SettingsKey.YT_USAGE_SYNC_SETTINGS)
        }
    }

    suspend fun getYpUsageSyncSettingsImmediate(tenantId: TenantId): YpUsageSyncSettings? {
        return dbSessionRetryable(tableClient) {
            runtimeSettingsDao.get(roStaleSingleRetryableCommit(), tenantId, SettingsKey.YP_USAGE_SYNC_SETTINGS)
        }
    }

    suspend fun getRateLimiterSettingsImmediate(tenantId: TenantId): RateLimiterSettings? {
        return dbSessionRetryable(tableClient) {
            runtimeSettingsDao.get(roStaleSingleRetryableCommit(), tenantId, SettingsKey.RATE_LIMITER_SETTINGS)
        }
    }

}
