package ru.yandex.intranet.d.services.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.services.sync.model.ExternalAccount;
import ru.yandex.intranet.d.services.sync.model.GroupedAccounts;

/**
 * Service to sync providers accounts and quotas, grouping utils part.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountsSyncGroupingUtils {

    private AccountsSyncGroupingUtils() {
    }

    @SuppressWarnings("ParameterNumber")
    public static GroupedAccounts groupAccounts(ProviderModel provider,
                                                Set<String> foldersPage,
                                                Map<String, List<ExternalAccount>> accountsByTargetFolder,
                                                Map<String, ExternalAccount> accountsByExternalId,
                                                List<AccountModel> currentFoldersPageAccounts,
                                                List<AccountModel> existingAccountsMovedToFoldersPage,
                                                Set<String> allReceivedAccountExternalIds) {
        Map<String, Map<String, AccountModel>> currentAccountsStay = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsStay = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsMovingOutSamePage = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutSamePage = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsMovingInSamePage = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInSamePage = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsMovingOutOtherPages = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutOtherPages = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsMovingInOtherPages = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInOtherPages = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToCreate = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteStay = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteStay = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutSamePage = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutSamePage = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInSamePage = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInSamePage = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInOtherPages = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInOtherPages = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutOtherPages = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutOtherPages = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsOuterFolders = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingIn = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingIn = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingOut = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingOut = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingIn = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingIn = new HashMap<>();
        Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingOut = new HashMap<>();
        Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingOut = new HashMap<>();
        Set<String> allAccountIds = new HashSet<>();
        Set<String> allExternalAccountIds = new HashSet<>();
        currentFoldersPageAccounts.forEach(account -> {
            allAccountIds.add(account.getId());
            allExternalAccountIds.add(account.getOuterAccountIdInProvider());
        });
        existingAccountsMovedToFoldersPage.forEach(account -> {
            allAccountIds.add(account.getId());
            allExternalAccountIds.add(account.getOuterAccountIdInProvider());
        });
        foldersPage.forEach(folderId -> accountsByTargetFolder
                .getOrDefault(folderId, Collections.emptyList()).forEach(account -> {
                    if (!allExternalAccountIds.contains(account.getAccountId())) {
                        receivedAccountsToCreate.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                                .put(account.getAccountId(), account);
                    }
                }));
        currentFoldersPageAccounts.forEach(account -> {
            if (accountsByExternalId.containsKey(account.getOuterAccountIdInProvider())) {
                ExternalAccount updatedAccount = accountsByExternalId.get(account.getOuterAccountIdInProvider());
                if (account.getFolderId().equals(updatedAccount.getFolderId())) {
                    groupAccountsThisPageStay(provider, currentAccountsStay, receivedAccountsStay,
                            currentAccountsToDeleteStay, receivedAccountsToDeleteStay, account, updatedAccount);
                } else {
                    if (foldersPage.contains(updatedAccount.getFolderId())) {
                        groupAccountsThisPageMoveSamePage(provider, currentAccountsMovingOutSamePage,
                                receivedAccountsMovingOutSamePage, currentAccountsMovingInSamePage,
                                receivedAccountsMovingInSamePage, currentAccountsToDeleteMovingOutSamePage,
                                receivedAccountsToDeleteMovingOutSamePage, currentAccountsToDeleteMovingInSamePage,
                                receivedAccountsToDeleteMovingInSamePage, account, updatedAccount);
                    } else {
                        groupAccountsThisPageMoveOtherPages(provider, currentAccountsMovingOutOtherPages,
                                receivedAccountsMovingOutOtherPages, currentAccountsToDeleteMovingOutOtherPages,
                                receivedAccountsToDeleteMovingOutOtherPages,
                                currentAccountsToDeleteOuterFoldersMovingIn,
                                receivedAccountsToDeleteOuterFoldersMovingIn, currentAccountsOuterFoldersMovingIn,
                                receivedAccountsOuterFoldersMovingIn, account, updatedAccount);
                    }
                }
            } else {
                if (allReceivedAccountExternalIds.contains(account.getOuterAccountIdInProvider())) {
                    currentAccountsStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                            .put(account.getOuterAccountIdInProvider(), account);
                } else if (provider.getAccountsSettings().isDeleteSupported()
                        && !provider.getAccountsSettings().isSoftDeleteSupported() && !account.isDeleted()) {
                    currentAccountsStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                            .put(account.getOuterAccountIdInProvider(), account);
                    currentAccountsToDeleteStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                            .put(account.getOuterAccountIdInProvider(), account);
                } else {
                    currentAccountsStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                            .put(account.getOuterAccountIdInProvider(), account);
                }
            }
        });
        existingAccountsMovedToFoldersPage.forEach(account -> {
            groupAccountsOtherPagesMoveThisPage(provider, accountsByExternalId, currentAccountsMovingInOtherPages,
                    receivedAccountsMovingInOtherPages, currentAccountsToDeleteMovingInOtherPages,
                    receivedAccountsToDeleteMovingInOtherPages, currentAccountsToDeleteOuterFoldersMovingOut,
                    receivedAccountsToDeleteOuterFoldersMovingOut, currentAccountsOuterFoldersMovingOut,
                    receivedAccountsOuterFoldersMovingOut, account);
        });
        return new GroupedAccounts(currentAccountsStay, receivedAccountsStay, currentAccountsMovingOutSamePage,
                receivedAccountsMovingOutSamePage, currentAccountsMovingInSamePage, receivedAccountsMovingInSamePage,
                currentAccountsMovingOutOtherPages, receivedAccountsMovingOutOtherPages,
                currentAccountsMovingInOtherPages, receivedAccountsMovingInOtherPages, receivedAccountsToCreate,
                currentAccountsToDeleteStay, receivedAccountsToDeleteStay, currentAccountsToDeleteMovingOutSamePage,
                receivedAccountsToDeleteMovingOutSamePage, currentAccountsToDeleteMovingInSamePage,
                receivedAccountsToDeleteMovingInSamePage, currentAccountsToDeleteMovingInOtherPages,
                receivedAccountsToDeleteMovingInOtherPages, currentAccountsToDeleteMovingOutOtherPages,
                receivedAccountsToDeleteMovingOutOtherPages, currentAccountsOuterFolders,
                currentAccountsToDeleteOuterFoldersMovingIn, receivedAccountsToDeleteOuterFoldersMovingIn,
                currentAccountsToDeleteOuterFoldersMovingOut, receivedAccountsToDeleteOuterFoldersMovingOut,
                currentAccountsOuterFoldersMovingIn, receivedAccountsOuterFoldersMovingIn,
                currentAccountsOuterFoldersMovingOut, receivedAccountsOuterFoldersMovingOut, allAccountIds);
    }

    @SuppressWarnings("ParameterNumber")
    private static void groupAccountsOtherPagesMoveThisPage(
            ProviderModel provider,
            Map<String, ExternalAccount> accountsByExternalId,
            Map<String, Map<String, AccountModel>> currentAccountsMovingInOtherPages,
            Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInOtherPages,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInOtherPages,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInOtherPages,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingOut,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingOut,
            Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingOut,
            Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingOut,
            AccountModel account) {
        ExternalAccount updatedAccount = accountsByExternalId.get(account.getOuterAccountIdInProvider());
        currentAccountsMovingInOtherPages.computeIfAbsent(updatedAccount.getFolderId(), k -> new HashMap<>())
                .put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsMovingInOtherPages.computeIfAbsent(updatedAccount.getFolderId(), k -> new HashMap<>())
                .put(updatedAccount.getAccountId(), updatedAccount);
        currentAccountsOuterFoldersMovingOut.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsOuterFoldersMovingOut.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(updatedAccount.getAccountId(), updatedAccount);
        if (provider.getAccountsSettings().isDeleteSupported()
                && provider.getAccountsSettings().isSoftDeleteSupported()
                && updatedAccount.isDeleted() && !account.isDeleted()) {
            currentAccountsToDeleteMovingInOtherPages.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteMovingInOtherPages.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
            currentAccountsToDeleteOuterFoldersMovingOut.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteOuterFoldersMovingOut.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        }
    }

    @SuppressWarnings("ParameterNumber")
    private static void groupAccountsThisPageMoveOtherPages(
            ProviderModel provider,
            Map<String, Map<String, AccountModel>> currentAccountsMovingOutOtherPages,
            Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutOtherPages,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutOtherPages,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutOtherPages,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingIn,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingIn,
            Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingIn,
            Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingIn,
            AccountModel account,
            ExternalAccount updatedAccount) {
        currentAccountsMovingOutOtherPages.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsMovingOutOtherPages.computeIfAbsent(account.getFolderId(),
                k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        currentAccountsOuterFoldersMovingIn.computeIfAbsent(updatedAccount.getFolderId(),
                k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsOuterFoldersMovingIn.computeIfAbsent(updatedAccount.getFolderId(),
                k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        if (provider.getAccountsSettings().isDeleteSupported()
                && provider.getAccountsSettings().isSoftDeleteSupported()
                && updatedAccount.isDeleted() && !account.isDeleted()) {
            currentAccountsToDeleteOuterFoldersMovingIn.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteOuterFoldersMovingIn.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
            currentAccountsToDeleteMovingOutOtherPages.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteMovingOutOtherPages.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        }
    }

    @SuppressWarnings("ParameterNumber")
    private static void groupAccountsThisPageMoveSamePage(
            ProviderModel provider,
            Map<String, Map<String, AccountModel>> currentAccountsMovingOutSamePage,
            Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutSamePage,
            Map<String, Map<String, AccountModel>> currentAccountsMovingInSamePage,
            Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInSamePage,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutSamePage,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutSamePage,
            Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInSamePage,
            Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInSamePage,
            AccountModel account,
            ExternalAccount updatedAccount) {
        currentAccountsMovingOutSamePage.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsMovingOutSamePage.computeIfAbsent(account.getFolderId(),
                k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        currentAccountsMovingInSamePage.computeIfAbsent(updatedAccount.getFolderId(),
                k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsMovingInSamePage.computeIfAbsent(updatedAccount.getFolderId(),
                k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        if (provider.getAccountsSettings().isDeleteSupported()
                && provider.getAccountsSettings().isSoftDeleteSupported()
                && updatedAccount.isDeleted() && !account.isDeleted()) {
            currentAccountsToDeleteMovingOutSamePage.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteMovingOutSamePage.computeIfAbsent(account.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
            currentAccountsToDeleteMovingInSamePage.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteMovingInSamePage.computeIfAbsent(updatedAccount.getFolderId(),
                    k -> new HashMap<>()).put(updatedAccount.getAccountId(), updatedAccount);
        }
    }

    @SuppressWarnings("ParameterNumber")
    private static void groupAccountsThisPageStay(ProviderModel provider,
                                           Map<String, Map<String, AccountModel>> currentAccountsStay,
                                           Map<String, Map<String, ExternalAccount>> receivedAccountsStay,
                                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteStay,
                                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteStay,
                                           AccountModel account,
                                           ExternalAccount updatedAccount) {
        currentAccountsStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(account.getOuterAccountIdInProvider(), account);
        receivedAccountsStay.computeIfAbsent(account.getFolderId(), k -> new HashMap<>())
                .put(updatedAccount.getAccountId(), updatedAccount);
        if (provider.getAccountsSettings().isDeleteSupported()
                && provider.getAccountsSettings().isSoftDeleteSupported() && updatedAccount.isDeleted()
                && !account.isDeleted()) {
            currentAccountsToDeleteStay.computeIfAbsent(updatedAccount.getFolderId(), k -> new HashMap<>())
                    .put(account.getOuterAccountIdInProvider(), account);
            receivedAccountsToDeleteStay.computeIfAbsent(updatedAccount.getFolderId(), k -> new HashMap<>())
                    .put(updatedAccount.getAccountId(), updatedAccount);
        }
    }

}
