package ru.yandex.intranet.d.services.sync;

import java.util.List;
import java.util.Set;

import ru.yandex.intranet.d.model.sync.ProvidersSyncErrorsModel;

/**
 * ProcessFoldersPageAccountsResult.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 13-04-2021
 */
public class ProcessFoldersPageAccountsResult {
    private final Set<String> postponedFolderIds;
    private final long receivedQuotasCount;
    private final List<ProvidersSyncErrorsModel> errors;
    private final boolean hasAnyErrors;

    public ProcessFoldersPageAccountsResult(
            Set<String> postponedFolderIds,
            long receivedQuotasCount,
            List<ProvidersSyncErrorsModel> errors,
            boolean hasAnyErrors
    ) {
        this.postponedFolderIds = postponedFolderIds;
        this.receivedQuotasCount = receivedQuotasCount;
        this.errors = errors;
        this.hasAnyErrors = hasAnyErrors;
    }

    public Set<String> getPostponedFolderIds() {
        return postponedFolderIds;
    }

    public long getReceivedQuotasCount() {
        return receivedQuotasCount;
    }

    public boolean hasErrors() {
        return hasAnyErrors || (errors != null && !errors.isEmpty());
    }

    public List<ProvidersSyncErrorsModel> getErrors() {
        return errors;
    }
}
