package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Account move folders.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountMoveFolders {

    private String sourceFolderId;
    private String destinationFolderId;

    public AccountMoveFolders() {
    }

    public Optional<String> getSourceFolderId() {
        return Optional.ofNullable(sourceFolderId);
    }

    public void setSourceFolderId(String sourceFolderId) {
        this.sourceFolderId = sourceFolderId;
    }

    public Optional<String> getDestinationFolderId() {
        return Optional.ofNullable(destinationFolderId);
    }

    public void setDestinationFolderId(String destinationFolderId) {
        this.destinationFolderId = destinationFolderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountMoveFolders that = (AccountMoveFolders) o;
        return Objects.equals(sourceFolderId, that.sourceFolderId) &&
                Objects.equals(destinationFolderId, that.destinationFolderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceFolderId, destinationFolderId);
    }

    @Override
    public String toString() {
        return "AccountMoveFolders{" +
                "sourceFolderId='" + sourceFolderId + '\'' +
                ", destinationFolderId='" + destinationFolderId + '\'' +
                '}';
    }

}
