package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Account move history cross reference.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountMoveHistoryXRef {

    private String sourceOpLogId;
    private String destinationOpLogId;

    public AccountMoveHistoryXRef() {
    }

    public Optional<String> getSourceOpLogId() {
        return Optional.ofNullable(sourceOpLogId);
    }

    public void setSourceOpLogId(String sourceOpLogId) {
        this.sourceOpLogId = sourceOpLogId;
    }

    public Optional<String> getDestinationOpLogId() {
        return Optional.ofNullable(destinationOpLogId);
    }

    public void setDestinationOpLogId(String destinationOpLogId) {
        this.destinationOpLogId = destinationOpLogId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountMoveHistoryXRef that = (AccountMoveHistoryXRef) o;
        return Objects.equals(sourceOpLogId, that.sourceOpLogId) &&
                Objects.equals(destinationOpLogId, that.destinationOpLogId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceOpLogId, destinationOpLogId);
    }

    @Override
    public String toString() {
        return "AccountMoveHistoryXRef{" +
                "sourceOpLogId='" + sourceOpLogId + '\'' +
                ", destinationOpLogId='" + destinationOpLogId + '\'' +
                '}';
    }

}
