package ru.yandex.intranet.d.services.sync.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * External account.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalAccount {

    private final String accountId;
    private final String key;
    private final String displayName;
    private final String folderId;
    private final boolean deleted;
    private final List<ExternalProvision> provisions;
    private final Long accountVersion;
    private final ExternalLastUpdate lastUpdate;
    private final int index;
    private final boolean freeTier;

    @SuppressWarnings("ParameterNumber")
    public ExternalAccount(String accountId, String key, String displayName, String folderId, boolean deleted,
                           List<ExternalProvision> provisions, Long accountVersion, ExternalLastUpdate lastUpdate,
                           int index, boolean freeTier) {
        this.accountId = accountId;
        this.key = key;
        this.displayName = displayName;
        this.folderId = folderId;
        this.deleted = deleted;
        this.provisions = provisions;
        this.accountVersion = accountVersion;
        this.lastUpdate = lastUpdate;
        this.index = index;
        this.freeTier = freeTier;
    }

    public String getAccountId() {
        return accountId;
    }

    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public String getFolderId() {
        return folderId;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public List<ExternalProvision> getProvisions() {
        return provisions;
    }

    public Optional<Long> getAccountVersion() {
        return Optional.ofNullable(accountVersion);
    }

    public Optional<ExternalLastUpdate> getLastUpdate() {
        return Optional.ofNullable(lastUpdate);
    }

    public int getIndex() {
        return index;
    }

    public boolean isFreeTier() {
        return freeTier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalAccount that = (ExternalAccount) o;
        return deleted == that.deleted &&
                index == that.index &&
                freeTier == that.freeTier &&
                Objects.equals(accountId, that.accountId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountVersion, that.accountVersion) &&
                Objects.equals(lastUpdate, that.lastUpdate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, key, displayName, folderId, deleted, provisions, accountVersion, lastUpdate,
                index, freeTier);
    }

    @Override
    public String toString() {
        return "ExternalAccount{" +
                "accountId='" + accountId + '\'' +
                ", key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", deleted=" + deleted +
                ", provisions=" + provisions +
                ", accountVersion=" + accountVersion +
                ", lastUpdate=" + lastUpdate +
                ", index=" + index +
                ", freeTier=" + freeTier +
                '}';
    }

}
