package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Set;

/**
 * External accounts space key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalAccountsSpaceKey {

    private final Set<ExternalSegmentKey> segments;

    public ExternalAccountsSpaceKey(Set<ExternalSegmentKey> segments) {
        this.segments = segments;
    }

    public Set<ExternalSegmentKey> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalAccountsSpaceKey that = (ExternalAccountsSpaceKey) o;
        return Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segments);
    }

    @Override
    public String toString() {
        return "ExternalAccountsSpaceKey{" +
                "segments=" + segments +
                '}';
    }

    public static final class ExternalSegmentKey {

        private final String segmentationKey;
        private final String segmentKey;

        public ExternalSegmentKey(String segmentationKey, String segmentKey) {
            this.segmentationKey = segmentationKey;
            this.segmentKey = segmentKey;
        }

        public String getSegmentationKey() {
            return segmentationKey;
        }

        public String getSegmentKey() {
            return segmentKey;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ExternalSegmentKey that = (ExternalSegmentKey) o;
            return Objects.equals(segmentationKey, that.segmentationKey) &&
                    Objects.equals(segmentKey, that.segmentKey);
        }

        @Override
        public int hashCode() {
            return Objects.hash(segmentationKey, segmentKey);
        }

        @Override
        public String toString() {
            return "ExternalSegmentKey{" +
                    "segmentationKey='" + segmentationKey + '\'' +
                    ", segmentKey='" + segmentKey + '\'' +
                    '}';
        }

    }

}
