package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Set;

/**
 * External compound resource key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalCompoundResourceKey {

    private final String resourceTypeKey;
    private final Set<ExternalCompoundSegmentKey> segments;

    public ExternalCompoundResourceKey(String resourceTypeKey, Set<ExternalCompoundSegmentKey> segments) {
        this.resourceTypeKey = resourceTypeKey;
        this.segments = segments;
    }

    public String getResourceTypeKey() {
        return resourceTypeKey;
    }

    public Set<ExternalCompoundSegmentKey> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalCompoundResourceKey that = (ExternalCompoundResourceKey) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segments);
    }

    @Override
    public String toString() {
        return "ExternalCompoundResourceKey{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segments=" + segments +
                '}';
    }

    public static final class ExternalCompoundSegmentKey {

        private final String segmentationKey;
        private final String segmentKey;

        public ExternalCompoundSegmentKey(String segmentationKey, String segmentKey) {
            this.segmentationKey = segmentationKey;
            this.segmentKey = segmentKey;
        }

        public String getSegmentationKey() {
            return segmentationKey;
        }

        public String getSegmentKey() {
            return segmentKey;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ExternalCompoundSegmentKey that = (ExternalCompoundSegmentKey) o;
            return Objects.equals(segmentationKey, that.segmentationKey) &&
                    Objects.equals(segmentKey, that.segmentKey);
        }

        @Override
        public int hashCode() {
            return Objects.hash(segmentationKey, segmentKey);
        }

        @Override
        public String toString() {
            return "ExternalCompoundSegmentKey{" +
                    "segmentationKey='" + segmentationKey + '\'' +
                    ", segmentKey='" + segmentKey + '\'' +
                    '}';
        }

    }

}
