package ru.yandex.intranet.d.services.sync.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

/**
 * External last update.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalLastUpdate {

    private final Instant timestamp;
    private final ExternalUserId author;
    private final String operationId;

    public ExternalLastUpdate(Instant timestamp, ExternalUserId author, String operationId) {
        this.timestamp = timestamp;
        this.author = author;
        this.operationId = operationId;
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public Optional<ExternalUserId> getAuthor() {
        return Optional.ofNullable(author);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalLastUpdate that = (ExternalLastUpdate) o;
        return Objects.equals(timestamp, that.timestamp) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timestamp, author, operationId);
    }

    @Override
    public String toString() {
        return "ExternalLastUpdate{" +
                "timestamp=" + timestamp +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                '}';
    }

}
