package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.units.UnitModel;

/**
 * External provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalProvision {

    private final SyncResource resource;
    private final long provided;
    private final UnitModel providedUnit;
    private final long allocated;
    private final UnitModel allocatedUnit;
    private final ExternalLastUpdate lastUpdate;
    private final Long quotaVersion;
    private final int index;

    @SuppressWarnings("ParameterNumber")
    public ExternalProvision(SyncResource resource, long provided, UnitModel providedUnit, long allocated,
                             UnitModel allocatedUnit, ExternalLastUpdate lastUpdate, Long quotaVersion,
                             int index) {
        this.resource = resource;
        this.provided = provided;
        this.providedUnit = providedUnit;
        this.allocated = allocated;
        this.allocatedUnit = allocatedUnit;
        this.lastUpdate = lastUpdate;
        this.quotaVersion = quotaVersion;
        this.index = index;
    }

    public SyncResource getResource() {
        return resource;
    }

    public long getProvided() {
        return provided;
    }

    public UnitModel getProvidedUnit() {
        return providedUnit;
    }

    public long getAllocated() {
        return allocated;
    }

    public UnitModel getAllocatedUnit() {
        return allocatedUnit;
    }

    public Optional<ExternalLastUpdate> getLastUpdate() {
        return Optional.ofNullable(lastUpdate);
    }

    public Optional<Long> getQuotaVersion() {
        return Optional.ofNullable(quotaVersion);
    }

    public int getIndex() {
        return index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalProvision that = (ExternalProvision) o;
        return provided == that.provided &&
                allocated == that.allocated &&
                index == that.index &&
                Objects.equals(resource, that.resource) &&
                Objects.equals(providedUnit, that.providedUnit) &&
                Objects.equals(allocatedUnit, that.allocatedUnit) &&
                Objects.equals(lastUpdate, that.lastUpdate) &&
                Objects.equals(quotaVersion, that.quotaVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, provided, providedUnit, allocated, allocatedUnit, lastUpdate,
                quotaVersion, index);
    }

    @Override
    public String toString() {
        return "ExternalProvision{" +
                "resource=" + resource +
                ", provided=" + provided +
                ", providedUnit=" + providedUnit +
                ", allocated=" + allocated +
                ", allocatedUnit=" + allocatedUnit +
                ", lastUpdate=" + lastUpdate +
                ", quotaVersion=" + quotaVersion +
                ", index=" + index +
                '}';
    }

}
