package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

/**
 * External user id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalUserId {

    private final String passportUid;
    private final String staffLogin;

    public ExternalUserId(String passportUid, String staffLogin) {
        this.passportUid = passportUid;
        this.staffLogin = staffLogin;
    }

    public Optional<String> getPassportUid() {
        return Optional.ofNullable(passportUid);
    }

    public Optional<String> getStaffLogin() {
        return Optional.ofNullable(staffLogin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalUserId that = (ExternalUserId) o;
        return Objects.equals(passportUid, that.passportUid) &&
                Objects.equals(staffLogin, that.staffLogin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(passportUid, staffLogin);
    }

    @Override
    public String toString() {
        return "ExternalUserId{" +
                "passportUid='" + passportUid + '\'' +
                ", staffLogin='" + staffLogin + '\'' +
                '}';
    }

}
