package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Folder history group key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FolderHistoryGroupKey {

    private final String operationId;
    private final String movedAccountId;

    public FolderHistoryGroupKey(String operationId, String movedAccountId) {
        this.operationId = operationId;
        this.movedAccountId = movedAccountId;
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    public Optional<String> getMovedAccountId() {
        return Optional.ofNullable(movedAccountId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderHistoryGroupKey that = (FolderHistoryGroupKey) o;
        return Objects.equals(operationId, that.operationId) &&
                Objects.equals(movedAccountId, that.movedAccountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId, movedAccountId);
    }

    @Override
    public String toString() {
        return "FolderHistoryGroupKey{" +
                "operationId='" + operationId + '\'' +
                ", movedAccountId='" + movedAccountId + '\'' +
                '}';
    }

}
