package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Folder operation author.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FolderOperationAuthor {

    private final String authorUserId;
    private final String authorUserUid;
    private final String authorProviderId;

    public FolderOperationAuthor(String authorUserId, String authorUserUid, String authorProviderId) {
        this.authorUserId = authorUserId;
        this.authorUserUid = authorUserUid;
        this.authorProviderId = authorProviderId;
    }

    public Optional<String> getAuthorUserId() {
        return Optional.ofNullable(authorUserId);
    }

    public Optional<String> getAuthorUserUid() {
        return Optional.ofNullable(authorUserUid);
    }

    public Optional<String> getAuthorProviderId() {
        return Optional.ofNullable(authorProviderId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderOperationAuthor that = (FolderOperationAuthor) o;
        return Objects.equals(authorUserId, that.authorUserId) &&
                Objects.equals(authorUserUid, that.authorUserUid) &&
                Objects.equals(authorProviderId, that.authorProviderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(authorUserId, authorUserUid, authorProviderId);
    }

    @Override
    public String toString() {
        return "FolderOperationAuthor{" +
                "authorUserId='" + authorUserId + '\'' +
                ", authorUserUid='" + authorUserUid + '\'' +
                ", authorProviderId='" + authorProviderId + '\'' +
                '}';
    }

}
