package ru.yandex.intranet.d.services.sync.model;

import java.util.Map;
import java.util.Set;

import ru.yandex.intranet.d.model.accounts.AccountModel;

/**
 * Grouped accounts.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class GroupedAccounts {

    private final Map<String, Map<String, AccountModel>> currentAccountsStay;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsStay;
    private final Map<String, Map<String, AccountModel>> currentAccountsMovingOutSamePage;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutSamePage;
    private final Map<String, Map<String, AccountModel>> currentAccountsMovingInSamePage;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInSamePage;
    private final Map<String, Map<String, AccountModel>> currentAccountsMovingOutOtherPages;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutOtherPages;
    private final Map<String, Map<String, AccountModel>> currentAccountsMovingInOtherPages;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInOtherPages;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToCreate;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteStay;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteStay;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutSamePage;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutSamePage;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInSamePage;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInSamePage;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInOtherPages;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInOtherPages;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutOtherPages;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutOtherPages;
    private final Map<String, Map<String, AccountModel>> currentAccountsOuterFolders;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingIn;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingIn;
    private final Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingOut;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingOut;
    private final Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingIn;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingIn;
    private final Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingOut;
    private final Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingOut;
    private final Set<String> allAccountIds;

    @SuppressWarnings("ParameterNumber")
    public GroupedAccounts(Map<String, Map<String, AccountModel>> currentAccountsStay,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsStay,
                           Map<String, Map<String, AccountModel>> currentAccountsMovingOutSamePage,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutSamePage,
                           Map<String, Map<String, AccountModel>> currentAccountsMovingInSamePage,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInSamePage,
                           Map<String, Map<String, AccountModel>> currentAccountsMovingOutOtherPages,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsMovingOutOtherPages,
                           Map<String, Map<String, AccountModel>> currentAccountsMovingInOtherPages,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsMovingInOtherPages,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToCreate,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteStay,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteStay,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutSamePage,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutSamePage,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInSamePage,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInSamePage,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingInOtherPages,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingInOtherPages,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteMovingOutOtherPages,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteMovingOutOtherPages,
                           Map<String, Map<String, AccountModel>> currentAccountsOuterFolders,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingIn,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingIn,
                           Map<String, Map<String, AccountModel>> currentAccountsToDeleteOuterFoldersMovingOut,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsToDeleteOuterFoldersMovingOut,
                           Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingIn,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingIn,
                           Map<String, Map<String, AccountModel>> currentAccountsOuterFoldersMovingOut,
                           Map<String, Map<String, ExternalAccount>> receivedAccountsOuterFoldersMovingOut,
                           Set<String> allAccountIds) {
        this.currentAccountsStay = currentAccountsStay;
        this.receivedAccountsStay = receivedAccountsStay;
        this.currentAccountsMovingOutSamePage = currentAccountsMovingOutSamePage;
        this.receivedAccountsMovingOutSamePage = receivedAccountsMovingOutSamePage;
        this.currentAccountsMovingInSamePage = currentAccountsMovingInSamePage;
        this.receivedAccountsMovingInSamePage = receivedAccountsMovingInSamePage;
        this.currentAccountsMovingOutOtherPages = currentAccountsMovingOutOtherPages;
        this.receivedAccountsMovingOutOtherPages = receivedAccountsMovingOutOtherPages;
        this.currentAccountsMovingInOtherPages = currentAccountsMovingInOtherPages;
        this.receivedAccountsMovingInOtherPages = receivedAccountsMovingInOtherPages;
        this.receivedAccountsToCreate = receivedAccountsToCreate;
        this.currentAccountsToDeleteStay = currentAccountsToDeleteStay;
        this.receivedAccountsToDeleteStay = receivedAccountsToDeleteStay;
        this.currentAccountsToDeleteMovingOutSamePage = currentAccountsToDeleteMovingOutSamePage;
        this.receivedAccountsToDeleteMovingOutSamePage = receivedAccountsToDeleteMovingOutSamePage;
        this.currentAccountsToDeleteMovingInSamePage = currentAccountsToDeleteMovingInSamePage;
        this.receivedAccountsToDeleteMovingInSamePage = receivedAccountsToDeleteMovingInSamePage;
        this.currentAccountsToDeleteMovingInOtherPages = currentAccountsToDeleteMovingInOtherPages;
        this.receivedAccountsToDeleteMovingInOtherPages = receivedAccountsToDeleteMovingInOtherPages;
        this.currentAccountsToDeleteMovingOutOtherPages = currentAccountsToDeleteMovingOutOtherPages;
        this.receivedAccountsToDeleteMovingOutOtherPages = receivedAccountsToDeleteMovingOutOtherPages;
        this.currentAccountsOuterFolders = currentAccountsOuterFolders;
        this.currentAccountsToDeleteOuterFoldersMovingIn = currentAccountsToDeleteOuterFoldersMovingIn;
        this.receivedAccountsToDeleteOuterFoldersMovingIn = receivedAccountsToDeleteOuterFoldersMovingIn;
        this.currentAccountsToDeleteOuterFoldersMovingOut = currentAccountsToDeleteOuterFoldersMovingOut;
        this.receivedAccountsToDeleteOuterFoldersMovingOut = receivedAccountsToDeleteOuterFoldersMovingOut;
        this.currentAccountsOuterFoldersMovingIn = currentAccountsOuterFoldersMovingIn;
        this.receivedAccountsOuterFoldersMovingIn = receivedAccountsOuterFoldersMovingIn;
        this.currentAccountsOuterFoldersMovingOut = currentAccountsOuterFoldersMovingOut;
        this.receivedAccountsOuterFoldersMovingOut = receivedAccountsOuterFoldersMovingOut;
        this.allAccountIds = allAccountIds;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsStay() {
        return currentAccountsStay;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsStay() {
        return receivedAccountsStay;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsMovingOutSamePage() {
        return currentAccountsMovingOutSamePage;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsMovingOutSamePage() {
        return receivedAccountsMovingOutSamePage;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsMovingInSamePage() {
        return currentAccountsMovingInSamePage;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsMovingInSamePage() {
        return receivedAccountsMovingInSamePage;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsMovingOutOtherPages() {
        return currentAccountsMovingOutOtherPages;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsMovingOutOtherPages() {
        return receivedAccountsMovingOutOtherPages;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsMovingInOtherPages() {
        return currentAccountsMovingInOtherPages;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsMovingInOtherPages() {
        return receivedAccountsMovingInOtherPages;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToCreate() {
        return receivedAccountsToCreate;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteStay() {
        return currentAccountsToDeleteStay;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteStay() {
        return receivedAccountsToDeleteStay;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteMovingOutSamePage() {
        return currentAccountsToDeleteMovingOutSamePage;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteMovingOutSamePage() {
        return receivedAccountsToDeleteMovingOutSamePage;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteMovingInSamePage() {
        return currentAccountsToDeleteMovingInSamePage;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteMovingInSamePage() {
        return receivedAccountsToDeleteMovingInSamePage;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteMovingInOtherPages() {
        return currentAccountsToDeleteMovingInOtherPages;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteMovingInOtherPages() {
        return receivedAccountsToDeleteMovingInOtherPages;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteMovingOutOtherPages() {
        return currentAccountsToDeleteMovingOutOtherPages;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteMovingOutOtherPages() {
        return receivedAccountsToDeleteMovingOutOtherPages;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsOuterFolders() {
        return currentAccountsOuterFolders;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteOuterFoldersMovingIn() {
        return currentAccountsToDeleteOuterFoldersMovingIn;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteOuterFoldersMovingIn() {
        return receivedAccountsToDeleteOuterFoldersMovingIn;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsToDeleteOuterFoldersMovingOut() {
        return currentAccountsToDeleteOuterFoldersMovingOut;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsToDeleteOuterFoldersMovingOut() {
        return receivedAccountsToDeleteOuterFoldersMovingOut;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsOuterFoldersMovingIn() {
        return currentAccountsOuterFoldersMovingIn;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsOuterFoldersMovingIn() {
        return receivedAccountsOuterFoldersMovingIn;
    }

    public Map<String, Map<String, AccountModel>> getCurrentAccountsOuterFoldersMovingOut() {
        return currentAccountsOuterFoldersMovingOut;
    }

    public Map<String, Map<String, ExternalAccount>> getReceivedAccountsOuterFoldersMovingOut() {
        return receivedAccountsOuterFoldersMovingOut;
    }

    public Set<String> getAllAccountIds() {
        return allAccountIds;
    }

}
