package ru.yandex.intranet.d.services.sync.model;

import java.util.Map;

import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Grouped authors.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class GroupedAuthors {

    private final Map<String, UserModel> authorsByUid;
    private final Map<String, UserModel> authorsByLogin;

    public GroupedAuthors(Map<String, UserModel> authorsByUid, Map<String, UserModel> authorsByLogin) {
        this.authorsByUid = authorsByUid;
        this.authorsByLogin = authorsByLogin;
    }

    public Map<String, UserModel> getAuthorsByUid() {
        return authorsByUid;
    }

    public Map<String, UserModel> getAuthorsByLogin() {
        return authorsByLogin;
    }

}
