package ru.yandex.intranet.d.services.sync.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.intranet.d.model.sync.ProvidersSyncErrorsModel;

/**
 * Process folders page result
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public class ProcessFoldersPageResult {
    private final Set<String> postponedFolderIds;
    private final Set<String> folderIdsWithMovedAccounts;
    private final Set<String> allReceivedAccountExternalIds;
    private final long receivedQuotasCount;
    private final List<ProvidersSyncErrorsModel> errors;
    private final boolean hasAnyErrors;

    public ProcessFoldersPageResult(
            Set<String> postponedFolderIds,
            Set<String> folderIdsWithMovedAccounts,
            Set<String> allReceivedAccountExternalIds,
            long receivedQuotasCount,
            List<ProvidersSyncErrorsModel> errors,
            boolean hasAnyErrors
    ) {
        this.postponedFolderIds = postponedFolderIds;
        this.folderIdsWithMovedAccounts = folderIdsWithMovedAccounts;
        this.allReceivedAccountExternalIds = allReceivedAccountExternalIds;
        this.receivedQuotasCount = receivedQuotasCount;
        this.errors = errors;
        this.hasAnyErrors = hasAnyErrors;
    }

    public Set<String> getPostponedFolderIds() {
        return postponedFolderIds;
    }

    public Set<String> getFolderIdsWithMovedAccounts() {
        return folderIdsWithMovedAccounts;
    }

    public Set<String> getAllReceivedAccountExternalIds() {
        return allReceivedAccountExternalIds;
    }

    public int getAllReceivedAccountExternalIdsSize() {
        return allReceivedAccountExternalIds != null ? allReceivedAccountExternalIds.size() : 0;
    }

    public long getReceivedQuotasCount() {
        return receivedQuotasCount;
    }

    public boolean hasErrors() {
        return hasAnyErrors || (errors != null && !errors.isEmpty());
    }

    public ProcessFoldersPageResult setHasErrors(boolean hasAnyErrors) {
        return new ProcessFoldersPageResult(
                postponedFolderIds,
                folderIdsWithMovedAccounts,
                allReceivedAccountExternalIds,
                receivedQuotasCount,
                errors,
                hasAnyErrors || this.hasAnyErrors
        );
    }

    public static ProcessFoldersPageResult concat(Iterable<ProcessFoldersPageResult> results) {
        Set<String> postponedFolderIds = new HashSet<>();
        Set<String> folderIdsWithMovedAccounts = new HashSet<>();
        Set<String> allReceivedAccountsIds = new HashSet<>();
        long receivedQuotasCount = 0;
        List<ProvidersSyncErrorsModel> errors = new ArrayList<>();
        boolean newHasAnyErrors = false;
        for (ProcessFoldersPageResult result : results) {
            if (result.postponedFolderIds != null) {
                postponedFolderIds.addAll(result.postponedFolderIds);
            }
            if (result.folderIdsWithMovedAccounts != null) {
                folderIdsWithMovedAccounts.addAll(result.folderIdsWithMovedAccounts);
            }
            if (result.allReceivedAccountExternalIds != null) {
                allReceivedAccountsIds.addAll(result.allReceivedAccountExternalIds);
            }
            receivedQuotasCount += result.receivedQuotasCount;
            errors.addAll(result.errors);
            newHasAnyErrors = newHasAnyErrors || result.hasAnyErrors;
        }
        return new ProcessFoldersPageResult(postponedFolderIds, folderIdsWithMovedAccounts, allReceivedAccountsIds,
                receivedQuotasCount, errors, newHasAnyErrors);
    }

    public static ProcessFoldersPageResult error(ProvidersSyncErrorsModel error) {
        return new ProcessFoldersPageResult(
                Set.of(),
                Set.of(),
                Set.of(),
                0L,
                List.of(error),
                true);
    }
}
