package ru.yandex.intranet.d.services.sync.model;

import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Quotas and operations.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class QuotasAndOperations {

    private final Map<String, Map<String, QuotaModel>> quotasByFolderResource;
    private final Map<String, Map<String, AccountsQuotasModel>> provisionsByAccountResource;
    private final Map<String, List<AccountsQuotasOperationsModel>> operationsByAccount;
    private final Set<String> operationsInProgress;
    private final Map<String, List<AccountsQuotasOperationsModel>> operationsInProgressByAccount;
    private final Map<String, AccountsQuotasOperationsModel> operationsById;

    public QuotasAndOperations(Map<String, Map<String, QuotaModel>> quotasByFolderResource,
                               Map<String, Map<String, AccountsQuotasModel>> provisionsByAccountResource,
                               Map<String, List<AccountsQuotasOperationsModel>> operationsByAccount,
                               Set<String> operationsInProgress,
                               Map<String, List<AccountsQuotasOperationsModel>> operationsInProgressByAccount,
                               Map<String, AccountsQuotasOperationsModel> operationsById) {
        this.quotasByFolderResource = quotasByFolderResource;
        this.provisionsByAccountResource = provisionsByAccountResource;
        this.operationsByAccount = operationsByAccount;
        this.operationsInProgress = operationsInProgress;
        this.operationsInProgressByAccount = operationsInProgressByAccount;
        this.operationsById = operationsById;
    }

    public Map<String, Map<String, QuotaModel>> getQuotasByFolderResource() {
        return quotasByFolderResource;
    }

    public Map<String, Map<String, AccountsQuotasModel>> getProvisionsByAccountResource() {
        return provisionsByAccountResource;
    }

    public Map<String, List<AccountsQuotasOperationsModel>> getOperationsByAccount() {
        return operationsByAccount;
    }

    public Set<String> getOperationsInProgress() {
        return operationsInProgress;
    }

    public Map<String, List<AccountsQuotasOperationsModel>> getOperationsInProgressByAccount() {
        return operationsInProgressByAccount;
    }

    public Map<String, AccountsQuotasOperationsModel> getOperationsById() {
        return operationsById;
    }

}
