package ru.yandex.intranet.d.services.sync.model;

import java.util.Objects;

import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;

/**
 * Expanded segment for synchronization.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SyncSegment {

    private final ResourceSegmentationModel segmentation;
    private final ResourceSegmentModel segment;

    public SyncSegment(ResourceSegmentationModel segmentation, ResourceSegmentModel segment) {
        this.segmentation = segmentation;
        this.segment = segment;
    }

    public ResourceSegmentationModel getSegmentation() {
        return segmentation;
    }

    public ResourceSegmentModel getSegment() {
        return segment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SyncSegment that = (SyncSegment) o;
        return Objects.equals(segmentation, that.segmentation) &&
                Objects.equals(segment, that.segment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation, segment);
    }

    @Override
    public String toString() {
        return "SyncSegment{" +
                "segmentation=" + segmentation +
                ", segment=" + segment +
                '}';
    }

}
