package ru.yandex.intranet.d.services.tracker;

import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.util.result.Result;
import ru.yandex.intranet.d.web.model.tracker.TrackerCreateTicketDto;
import ru.yandex.intranet.d.web.model.tracker.TrackerCreateTicketResponseDto;
import ru.yandex.intranet.d.web.model.tracker.TrackerTransitionExecuteDto;
import ru.yandex.intranet.d.web.model.tracker.TrackerUpdateTicketDto;

/**
 * Tracker client
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public interface TrackerClient {

    Mono<Result<TrackerCreateTicketResponseDto>> createTicket(TrackerCreateTicketDto request);

    Mono<Result<Void>> updateTicket(String ticketKey, TrackerUpdateTicketDto request);

    Mono<Result<Void>> closeTicket(String ticketKey, String transition,
                                   TrackerTransitionExecuteDto request);
}
